(function(){
  if (window.__RSQ_FORCE_ADDON__) return; 
  window.__RSQ_FORCE_ADDON__ = true;

  const $  = (s, r=document) => r.querySelector(s);
  const $$ = (s, r=document) => Array.from(r.querySelectorAll(s));
  function byId(id){ return document.getElementById(id); }

  const LS_KEY = 'rscpid_tasks_queue_v3';
  const TaskStatus = { 
    WAIT:'Bekliyor', 
    TRY:'Çalışıyor', 
    OK:'Başarılı', 
    FAIL:'Başarısız' 
  };
  
  const SchedulerStatus = {
    STOPPED: 'Duraklatıldı',
    RUNNING: 'Çalışıyor',
    PAUSED: 'Duraklatıldı'
  };

  function load(){ 
    try{ return JSON.parse(localStorage.getItem(LS_KEY)||'[]'); } 
    catch{ return []; } 
  }
  
  function save(list){ 
    try{ localStorage.setItem(LS_KEY, JSON.stringify(list)); } 
    catch{} 
  }
  
  let tasks = load();
  let schedulerState = SchedulerStatus.STOPPED;
  let schedulerInterval = null;
  let activeTasks = 0;
    const inFlight = new Set();                 
	const MAX_CONCURRENT_TASKS = 5; 
  const CHINA_WINDOW_DURATION = 30 * 60 * 1000;
 
  const digits = v => (v||'').toString().replace(/\D/g,'');
  
  async function runWithSlot(task){

  if (inFlight.has(task.id)) return false;
  if (activeTasks >= MAX_CONCURRENT_TASKS) return false;

  activeTasks++;
  inFlight.add(task.id);
  try {
    
    const now = cnNow();
    if (!task.currentWindowStart || !task.currentWindowEnd) {
      task.currentWindowStart = now;
      task.currentWindowEnd   = new Date(now.getTime() + CHINA_WINDOW_DURATION);
      save(tasks);
    }
    await executeTask(task);
  } finally {
    inFlight.delete(task.id);
    activeTasks = Math.max(0, activeTasks - 1);
  }
  return true;
}
  
  function luhn14(n14){
    if (!n14 || n14.length!==14) return '';
    let sum=0, dbl=true;
    for(let i=13;i>=0;i--){
      let d = n14.charCodeAt(i)-48;
      if(dbl){ d*=2; if(d>9) d-=9; }
      sum+=d; dbl=!dbl;
    }
    return String((10-(sum%10))%10);
  }
  
  function randomImei(base='3560'){
    let core=(base+Math.floor(Math.random()*1e12)).slice(0,14);
    return core + luhn14(core);
  }
  
  function ensureImei(val){
    const t=(val||'').trim().toLowerCase();
    if (t.startsWith('padhex')) return (val||'');
    const d=digits(t);
    if (d.length===15) return d;
    if (d.length===14) return d + luhn14(d);
    if (!d.length) return randomImei();
    const core=(d+'00000000000000').slice(0,14);
    return core + luhn14(core);
  }

  const CN_TZ='Asia/Shanghai';
  const cnNow = () => new Date(new Date().toLocaleString('en-US',{timeZone:CN_TZ}));
  const mkC = (n,h,m,s)=>{ const d=new Date(n); d.setHours(h,m,s,0); return d; };
  
  function getChinaWindow(){
    const now = cnNow();
    const mins = now.getHours()*60 + now.getMinutes();
    const m01=60, m2358=23*60+58, m0028=24*60+28;
    
    let startC, endC;
    if (mins < m01) { 
      startC = now; 
      endC = new Date(startC.getTime() + CHINA_WINDOW_DURATION);
    } else if (mins < m2358) { 
      startC = mkC(now,23,58,0); 
      endC = new Date(startC.getTime() + CHINA_WINDOW_DURATION);
    } else if (mins < m0028) { 
      startC = now; 
      endC = mkC(now,0,28,0);
    } else { 
      const tomorrow = new Date(now); 
      tomorrow.setDate(tomorrow.getDate() + 1); 
      startC = mkC(tomorrow,23,58,0);
      endC = new Date(startC.getTime() + CHINA_WINDOW_DURATION);
    }
    return {startC, endC};
  }
  
  function remainStr(ms){
    if (ms<=0) return "00:00:00";
    const h=String(Math.floor(ms/3600000)).padStart(2,'0');
    const m=String(Math.floor((ms%3600000)/60000)).padStart(2,'0');
    const s=String(Math.floor((ms%60000)/1000)).padStart(2,'0');
    return `${h}:${m}:${s}`;
  }

  function getTaskTimeInfo(task) {
    const now = cnNow();
    const window = getChinaWindow();
    
    if (task.currentWindowStart && task.currentWindowEnd) {
      const remaining = task.currentWindowEnd - now;
      return {
        canSend: remaining > 0,
        timeRemaining: remainStr(Math.max(0, remaining)),
        timeLabel: 'Pencerede kalan',
        windowStart: task.currentWindowStart,
        windowEnd: task.currentWindowEnd
      };
    }
    
    const canSend = (now >= window.startC && now <= window.endC);
    const timeRemaining = canSend ? 
      remainStr(window.endC - now) : 
      remainStr(window.startC - now);
    const timeLabel = canSend ? 'Pencerede kalan' : 'Başlamaya kalan';
    
    return { canSend, timeRemaining, timeLabel, windowStart: window.startC, windowEnd: window.endC };
  }

  function val(...sels){
    for (const s of sels){
      const el = typeof s==='string' ? $(s) : s;
      if (el && 'value' in el) return el.value;
    }
    return '';
  }
  
  function findInputByLabelText(text){
    const labels = $$('label');
    const l = labels.find(x => (x.textContent||'').trim().toLowerCase().includes(text));
    if (!l) return null;
    const forId = l.getAttribute('for'); if (forId) return byId(forId);
    return l.querySelector('input,textarea');
  }
  
  function readForm(){
    const product = val('#product','[name="product"]','[name*="product" i]') || (findInputByLabelText('product')?.value||'');
    const cpuId   = val('#cpuId','[name="cpuid"]','[name*="cpu" i]') || (findInputByLabelText('cpu')?.value||'');
    const imei1   = val('#imei1','[name="imei1"]','[name*="imei1" i]','[name*="imei" i]') || (findInputByLabelText('imei 1')?.value||'');
    const imei2   = val('#imei2','[name="imei2"]','[name*="imei2" i]') || (findInputByLabelText('imei 2')?.value||'');
    const btmac   = val('#btmac','[name="btmac"]','[name*="bt" i]','[placeholder*="BT" i]') || (findInputByLabelText('bt')?.value||'');
    const wmac    = val('#wmac','[name="wmac"]','[name*="wifi" i]','[placeholder*="wifi" i]') || (findInputByLabelText('wi-fi')?.value||findInputByLabelText('wifi')?.value||'');

    return {
      product: (product||'').trim(),
      cpuId:   (cpuId||'').trim(),
      imei1:   ensureImei(imei1),
      imei2:   ensureImei(imei2),
      btmac:   (btmac||'').trim(),
      wmac:    (wmac||'').trim()
    };
  }

  // ---------- Enhanced UI Styling ----------
  function injectCSS(){
    if (byId('rsq-force-css')) return;
    const css = document.createElement('style');
    css.id = 'rsq-force-css';
    css.textContent = `
      .rsq-fab {
        position: fixed;
        right: 20px;
        bottom: 20px;
        z-index: 99999;
        display: flex;
        flex-direction: column;
        gap: 10px;
        font-family: inherit;
      }

      .rsq-modal {
        position: fixed;
        inset: 0;
        background: rgba(0, 0, 0, 0.7);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 100000;
        backdrop-filter: blur(4px);
      }

      .rsq-modal.show {
        display: flex;
      }

      .rsq-card {
        width: min(1200px, 94vw);
        height: min(800px, 90vh);
        border: 1px solid var(--border, #27272a);
        background: var(--panel, #18181b);
        border-radius: 16px;
        box-shadow: var(--elev-2);
        display: flex;
        flex-direction: column;
        overflow: hidden;
      }

      .rsq-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px 20px;
        border-bottom: 1px solid var(--border, #27272a);
        background: color-mix(in oklab, var(--panel) 92%, black 8%);
      }

      .rsq-title {
        font-weight: 700;
        font-size: 18px;
        color: var(--fg);
        display: flex;
        align-items: center;
        gap: 10px;
      }

      .scheduler-status {
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
      }

      .scheduler-status.running {
        background: rgba(34, 197, 94, 0.15);
        color: #22c55e;
        border: 1px solid rgba(34, 197, 94, 0.3);
      }

      .scheduler-status.stopped {
        background: rgba(239, 68, 68, 0.15);
        color: #ef4444;
        border: 1px solid rgba(239, 68, 68, 0.3);
      }

      .scheduler-status.paused {
        background: rgba(245, 158, 11, 0.15);
        color: #f59e0b;
        border: 1px solid rgba(245, 158, 11, 0.3);
      }

      .rsq-body {
        flex: 1;
        padding: 0;
        overflow: hidden;
        display: flex;
        flex-direction: column;
      }

      .task-table-container {
        flex: 1;
        overflow: auto;
        padding: 0;
      }

      .task-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
      }

      .task-table th {
        background: color-mix(in oklab, var(--panel) 85%, black 15%);
        color: var(--muted);
        font-weight: 700;
        padding: 12px 8px;
        border-bottom: 1px solid var(--border);
        position: sticky;
        top: 0;
        z-index: 2;
      }

      .task-table td {
        padding: 10px 8px;
        border-bottom: 1px solid var(--border);
        vertical-align: middle;
      }

      .task-table tr:nth-child(even) td {
        background: color-mix(in oklab, var(--panel) 98%, black 2%);
      }

      .task-table tr:hover td {
        background: color-mix(in oklab, var(--panel) 94%, black 6%);
      }

      .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        border: 1px solid;
      }

      .status-waiting {
        background: rgba(59, 130, 246, 0.1);
        color: #60a5fa;
        border-color: rgba(59, 130, 246, 0.3);
      }

      .status-running {
        background: rgba(245, 158, 11, 0.1);
        color: #fbbf24;
        border-color: rgba(245, 158, 11, 0.3);
      }

      .status-success {
        background: rgba(34, 197, 94, 0.1);
        color: #4ade80;
        border-color: rgba(34, 197, 94, 0.3);
      }

      .status-failed {
        background: rgba(239, 68, 68, 0.1);
        color: #f87171;
        border-color: rgba(239, 68, 68, 0.3);
      }

      .imei-badge {
        font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, monospace;
        font-size: 11px;
        padding: 4px 8px;
        background: color-mix(in oklab, var(--panel) 90%, black 10%);
        border: 1px solid var(--border);
        border-radius: 6px;
        color: var(--fg);
      }

      .product-badge {
        padding: 4px 10px;
        background: linear-gradient(135deg, #3b82f6, #a855f7);
        color: white;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
      }

      .time-badge {
        font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, monospace;
        font-size: 12px;
        color: var(--muted);
        background: color-mix(in oklab, var(--panel) 95%, black 5%);
        padding: 4px 8px;
        border-radius: 6px;
        border: 1px solid var(--border);
      }

      .action-buttons {
        display: flex;
        gap: 6px;
        align-items: center;
      }

      .btn-compact {
        padding: 6px 10px !important;
        font-size: 11px !important;
        border-radius: 8px !important;
        min-width: auto !important;
      }

      .stats-bar {
        display: flex;
        align-items: center;
        gap: 16px;
        padding: 12px 20px;
        border-top: 1px solid var(--border);
        background: color-mix(in oklab, var(--panel) 92%, black 8%);
        font-size: 13px;
      }

      .stat-item {
        display: flex;
        align-items: center;
        gap: 6px;
        color: var(--muted);
      }

      .stat-value {
        font-weight: 700;
        color: var(--fg);
      }

      .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--muted);
      }

      .empty-state svg {
        margin-bottom: 16px;
        opacity: 0.5;
      }

      @media (max-width: 768px) {
        .rsq-card {
          width: 95vw;
          height: 90vh;
          margin: 20px;
        }
        
        .rsq-header {
          flex-direction: column;
          gap: 12px;
          align-items: flex-start;
        }
        
        .task-table {
          font-size: 11px;
        }
        
        .action-buttons {
          flex-direction: column;
        }
      }
    `;
    document.head.appendChild(css);
  }

  function ensureUI(){
    injectCSS();
    
    byId('rsq-fab')?.remove();
    byId('rsq-modal')?.remove();

    const fab = document.createElement('div');
    fab.id = 'rsq-fab'; 
    fab.className = 'rsq-fab';
    fab.innerHTML = `
      <button class="btn primary qa-tile qa-acc-blue" id="rsqAdd" style="display:flex;align-items:center;gap:8px">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <path d="M12 5v14M5 12h14"/>
        </svg>
        Görev Ekle
      </button>
      <button class="btn secondary qa-tile qa-acc-purple" id="rsqOpen" style="display:flex;align-items:center;gap:8px">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <path d="M9 17H7A5 5 0 017 7h2m6 0h2a5 5 0 110 10h-2m-6 0h6"/>
        </svg>
        Görevler (${tasks.length})
      </button>`;
    document.body.appendChild(fab);

    const m = document.createElement('div');
    m.className = 'rsq-modal'; 
    m.id = 'rsq-modal';
    m.innerHTML = `
      <div class="rsq-card">
        <div class="rsq-header">
          <div class="rsq-title">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
              <path d="M9 17H7A5 5 0 017 7h2m6 0h2a5 5 0 110 10h-2m-6 0h6"/>
            </svg>
            Görev Yöneticisi
            <span class="scheduler-status stopped" id="schedulerStatus">Duraklatıldı</span>
          </div>
          <div class="row">
            <button class="btn success qa-tile qa-acc-green" id="btnStartScheduler" style="display:flex;align-items:center;gap:6px">
              <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <polygon points="5 3 19 12 5 21 5 3"/>
              </svg>
              Başlat
            </button>
            <button class="btn warn qa-tile qa-acc-yellow" id="btnPauseScheduler" style="display:flex;align-items:center;gap:6px">
              <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <rect x="6" y="4" width="4" height="16"/>
                <rect x="14" y="4" width="4" height="16"/>
              </svg>
              Duraklat
            </button>
            <button class="btn err qa-tile qa-acc-red" id="btnClearDone" style="display:flex;align-items:center;gap:6px">
              <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M3 6h18M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2"/>
              </svg>
              Temizle
            </button>
            <button class="btn ghost qa-tile" id="rsqClose" style="display:flex;align-items:center;gap:6px">
              <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M18 6L6 18M6 6l12 12"/>
              </svg>
              Kapat
            </button>
          </div>
        </div>
        <div class="rsq-body">
          <div class="task-table-container">
            <table class="task-table" id="tasksTable">
              <thead>
                <tr>
                  <th style="width:100px">İşlem</th>
                  <th style="width:120px">Product</th>
                  <th>IMEI 1</th>
                  <th>IMEI 2</th>
                  <th style="width:120px">Kalan Süre</th>
                  <th style="width:120px">Durum</th>
                  <th style="width:140px">İşlemler</th>
                </tr>
              </thead>
              <tbody id="tasksTbody">
                <tr>
                  <td colspan="7" class="empty-state">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                      <path d="M9 17H7A5 5 0 017 7h2m6 0h2a5 5 0 110 10h-2m-6 0h6"/>
                    </svg>
                    <div>Henüz görev bulunmuyor</div>
                    <div style="font-size:12px; margin-top:8px;">Formu doldurup "Görev Ekle" butonuna tıklayın</div>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          <div class="stats-bar">
            <div class="stat-item">
              <span>Toplam:</span>
              <span class="stat-value" id="statTotal">0</span>
            </div>
            <div class="stat-item">
              <span>Bekleyen:</span>
              <span class="stat-value" id="statWaiting">0</span>
            </div>
            <div class="stat-item">
              <span>Çalışan:</span>
              <span class="stat-value" id="statRunning">0</span>
            </div>
            <div class="stat-item">
              <span>Başarılı:</span>
              <span class="stat-value" id="statSuccess">0</span>
            </div>
            <div class="stat-item">
              <span>Başarısız:</span>
              <span class="stat-value" id="statFailed">0</span>
            </div>
          </div>
        </div>
      </div>`;
    document.body.appendChild(m);
  }

  function updateStats() {
    const total = tasks.length;
    const waiting = tasks.filter(t => t.status === TaskStatus.WAIT).length;
    const running = tasks.filter(t => t.status === TaskStatus.TRY).length;
    const success = tasks.filter(t => t.status === TaskStatus.OK).length;
    const failed = tasks.filter(t => t.status === TaskStatus.FAIL).length;

    const statTotalEl = byId('statTotal');
    const statWaitingEl = byId('statWaiting');
    const statRunningEl = byId('statRunning');
    const statSuccessEl = byId('statSuccess');
    const statFailedEl = byId('statFailed');

    if (statTotalEl) statTotalEl.textContent = total;
    if (statWaitingEl) statWaitingEl.textContent = waiting;
    if (statRunningEl) statRunningEl.textContent = running;
    if (statSuccessEl) statSuccessEl.textContent = success;
    if (statFailedEl) statFailedEl.textContent = failed;

    const fabBtn = byId('rsqOpen');
    if (fabBtn) {
      fabBtn.innerHTML = `
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <path d="M9 17H7A5 5 0 017 7h2m6 0h2a5 5 0 110 10h-2m-6 0h6"/>
        </svg>
        Görevler (${total})
      `;
    }
  }

  function getStatusBadge(status) {
    const statusConfig = {
      [TaskStatus.WAIT]: { class: 'status-waiting', label: 'Bekliyor' },
      [TaskStatus.TRY]: { class: 'status-running', label: 'Çalışıyor' },
      [TaskStatus.OK]: { class: 'status-success', label: 'Başarılı' },
      [TaskStatus.FAIL]: { class: 'status-failed', label: 'Başarısız' }
    };
    
    const config = statusConfig[status] || statusConfig[TaskStatus.WAIT];
    return `<span class="status-badge ${config.class}">${config.label}</span>`;
  }

  function formatImei(imei) {
    if (!imei) return '-';
    return imei.length === 15 ? imei : `${imei} (${imei.length}h)`;
  }

  function render() {
    const tb = byId('tasksTbody');
    if (!tb) return;

    if (tasks.length === 0) {
      tb.innerHTML = `
        <tr>
          <td colspan="7" class="empty-state">
            <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
              <path d="M9 17H7A5 5 0 017 7h2m6 0h2a5 5 0 110 10h-2m-6 0h6"/>
            </svg>
            <div>Henüz görev bulunmuyor</div>
            <div style="font-size:12px; margin-top:8px;">Formu doldurup "Görev Ekle" butonuna tıklayın</div>
          </td>
        </tr>`;
      updateStats();
      return;
    }

    let html = '';
    tasks.forEach(task => {
      const timeInfo = getTaskTimeInfo(task);

      html += `
        <tr data-id="${task.id}">
          <td>
            <span class="product-badge">Critical</span>
          </td>
          <td>
            <strong style="color:var(--fg); font-family:ui-monospace">${(task.product || '').toUpperCase()}</strong>
          </td>
          <td>
            <span class="imei-badge">${formatImei(task.imei1)}</span>
          </td>
          <td>
            <span class="imei-badge">${formatImei(task.imei2)}</span>
          </td>
          <td>
            <span class="time-badge" title="${timeInfo.timeLabel}: ${timeInfo.timeRemaining}">
              ${timeInfo.timeRemaining}
            </span>
          </td>
          <td>
            ${getStatusBadge(task.status)}
            ${task.attempts ? `<div style="font-size:10px; color:var(--muted); margin-top:2px;">Deneme: ${task.attempts}</div>` : ''}
          </td>
          <td>
            <div class="action-buttons">
              <button class="btn success btn-compact" data-act="try" title="Hemen Dene" ${task.status === TaskStatus.TRY ? 'disabled' : ''}>
                <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                  <polygon points="5 3 19 12 5 21 5 3"/>
                </svg>
              </button>
              <button class="btn warn btn-compact" data-act="edit" title="Düzenle">
                <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                  <path d="M11 4H4a2 2 0 00-2 2v14a2 2 0 002 2h14a2 2 0 002-2v-7"/>
                  <path d="M18.5 2.5a2.121 2.121 0 013 3L12 15l-4 1 1-4 9.5-9.5z"/>
                </svg>
              </button>
              <button class="btn err btn-compact" data-act="del" title="Sil">
                <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                  <path d="M3 6h18M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2"/>
                </svg>
              </button>
            </div>
          </td>
        </tr>`;
    });

    tb.innerHTML = html;
    updateStats();
  }

  function addFromForm(){
    const formData = readForm();
    
    if (!formData.product || !formData.cpuId) {
      showNotification('Product ve CPU ID alanları zorunludur!', 'error');
      return;
    }

    const task = {
      id: 'task_' + Date.now() + '_' + Math.random().toString(36).slice(2, 8),
      kind: 'Critical',
      ...formData,
      status: TaskStatus.WAIT,
      createdAt: Date.now(),
      updatedAt: Date.now(),
      attempts: 0,
      lastError: '',
      currentWindowStart: null,
      currentWindowEnd: null
    };
    
    tasks.push(task); 
    save(tasks); 
    render();
    
    showNotification(`Görev eklendi: ${task.product.toUpperCase()}`, 'success');
    
    try { 
      (window.logLine || console.log)(`✓ Görev eklendi → ${task.product} / ${task.imei1}`); 
    } catch {}
  }

function showNotification(message, type = 'info') {
  if (window.logLine) {
    let formattedMessage = message;
    let colorType = type;
    
    if (message.includes('✗') && message.includes('tekrar deneniyor:')) {
      const match = message.match(/✗(.*?)tekrar deneniyor:\s*([^(]+)\((\d+)\. deneme\)/);
      if (match) {
        const prefix = match[1].trim();
        const product = match[2].trim();
        const attempt = match[3];
        
        formattedMessage = 
          `<span style="color: #ef4444">✗${prefix}</span>` +
          `<span style="color: #93c5fd">tekrar deneniyor:</span> ` +
          `<span style="color: #3b82f6; font-weight: bold">${product}</span> ` +
          `<span style="color: #f59e0b">(${attempt}. deneme)</span>`;
        colorType = 'custom';
      }
    }
    else if (message.includes('✓') && message.includes('başarılı:')) {
      const match = message.match(/✓(.*?)başarılı:\s*(.+)/);
      if (match) {
        const prefix = match[1].trim();
        const product = match[2].trim();
        
        formattedMessage = 
          `<span style="color: #22c55e">✓${prefix}</span>` +
          `<span style="color: #86efac">başarılı:</span> ` +
          `<span style="color: #16a34a; font-weight: bold">${product}</span>`;
        colorType = 'custom';
      }
    }
    else if (message.includes('✗') && message.includes('başarısız:')) {
      const match = message.match(/✗(.*?)başarısız:\s*([^(]+)\(Toplam\s+(\d+)\s+deneme\)/);
      if (match) {
        const prefix = match[1].trim();
        const product = match[2].trim();
        const totalAttempts = match[3];
        
        formattedMessage = 
          `<span style="color: #dc2626">✗${prefix}</span>` +
          `<span style="color: #fca5a5">başarısız:</span> ` +
          `<span style="color: #b91c1c; font-weight: bold">${product}</span> ` +
          `<span style="color: #d97706">(Toplam ${totalAttempts} deneme)</span>`;
        colorType = 'custom';
      }
    }
    
    const colorMap = { 
      success: 'ok', 
      error: 'err', 
      info: 'info', 
      warning: 'warn',
      custom: 'info'
    };
    window.logLine(formattedMessage, colorMap[colorType] || 'info');
  } else {
    console.log(`[${type.toUpperCase()}] ${message}`);
  }
}

  function updateSchedulerStatus() {
    const statusEl = byId('schedulerStatus');
    if (!statusEl) return;

    statusEl.textContent = schedulerState;
    statusEl.className = 'scheduler-status';
    
    switch(schedulerState) {
      case SchedulerStatus.RUNNING:
        statusEl.classList.add('running');
        break;
      case SchedulerStatus.PAUSED:
        statusEl.classList.add('paused');
        break;
      default:
        statusEl.classList.add('stopped');
    }
  }

  // ---------- Scheduler System ----------
	function processNextTask() {
	  if (activeTasks >= MAX_CONCURRENT_TASKS) return;

	  const now = cnNow();
	  const window = getChinaWindow();
	  const canSend = (now >= window.startC && now <= window.endC);
	  if (!canSend) return;

	  const task = tasks.find(t => t.status === TaskStatus.WAIT);
	  if (!task) return;

	  runWithSlot(task); // aktif slot varsa çalıştır
	}


const taskTimeouts = new Map();

async function executeTask(task) {
  if (taskTimeouts.has(task.id)) {
    clearTimeout(taskTimeouts.get(task.id));
    taskTimeouts.delete(task.id);
  }

  task.status = TaskStatus.TRY;
  task.attempts = (task.attempts || 0) + 1;
  task.updatedAt = Date.now();
  save(tasks);
  render();

  try {
    let success = false;
    
    if (typeof window.createCriticalOnServer === 'function') {
      const originalLogLine = window.logLine;
      const originalUpdateGlobalStatus = window.updateGlobalStatus;
      
      window.logLine = function() {}; 
      window.updateGlobalStatus = function() {}; 
      
      try {
        await createCriticalOnServerWithTaskData(task);
        
        const dl = document.getElementById('downloadLink');
        success = !!(dl && dl.style.display !== 'none');
      } finally {
        window.logLine = originalLogLine;
        window.updateGlobalStatus = originalUpdateGlobalStatus;
      }
      
      if (success) {
        task.status = TaskStatus.OK;
        task.currentWindowStart = null;
        task.currentWindowEnd = null;
        showNotification(`✓ Görev başarılı: ${task.product.toUpperCase()}`, 'success');
        if (window.logLine) {
          window.logLine(`✓ Görev tamamlandı: ${task.product.toUpperCase()} - ${task.imei1}`, 'ok');
        }
      } else {
        throw new Error('Dosya oluşturulamadı');
      }
    } else {
      throw new Error('Critical fonksiyonu bulunamadı');
    }
  } catch (error) {
    task.status = TaskStatus.FAIL;
    task.lastError = error?.message || String(error);
    
    const now = cnNow();
    
    const taskStillExists = tasks.some(t => t.id === task.id);
    if (taskStillExists && task.currentWindowEnd && now < task.currentWindowEnd) {
      task.status = TaskStatus.WAIT;
      save(tasks);
      render();
      
      if (task.attempts <= 5 || task.attempts % 5 === 0) {
        showNotification(`✗ Görev başarısız, tekrar deneniyor: ${task.product.toUpperCase()} (${task.attempts}. deneme)`, 'warning');
      }
      
		const timeoutId = setTimeout(() => {
		  const taskStillExists = tasks.some(t => t.id === task.id);
		  if (taskStillExists && task.status === TaskStatus.WAIT && task.currentWindowEnd && cnNow() < task.currentWindowEnd) {
			runWithSlot(task); 
		  }
		  taskTimeouts.delete(task.id);
		}, 200);

      
      taskTimeouts.set(task.id, timeoutId);
    } else {
      task.currentWindowStart = null;
      task.currentWindowEnd = null;
      showNotification(`✗ Görev başarısız: ${task.product.toUpperCase()} (Toplam ${task.attempts} deneme)`, 'error');
      if (window.logLine) {
        window.logLine(`✗ Görev başarısız: ${task.product.toUpperCase()} - ${task.imei1} (${task.attempts} deneme)`, 'err');
      }
    }
  } finally {
    task.updatedAt = Date.now();
    save(tasks);
    render();
  }
}

async function createCriticalOnServerWithTaskData(task) {
  

  if (currentUserCredit < 1) {
    throw new Error("Yetersiz kredi! En az 1 kredi gerekiyor.");
  }

  const product = (task.product || "").trim();
  const cpuId   = (task.cpuId   || "").trim();
  if (!product || product === "—" || !cpuId || cpuId === "N/A") {
    throw new Error("Product veya CPU ID boş olamaz.");
  }

  
  let i1_14 = sanitize14(task.imei1);
  const SAFE_TACS = ["8614600540", "8628440599", "8697060565", "8631680780"];
  if (i1_14.length !== 14 || !SAFE_TACS.some(t => i1_14.startsWith(t))) {
    throw new Error("Geçersiz IMEI1");
  }
  const i1_full = i1_14 + calcLuhn14to15(i1_14);

  let i2_14   = sanitize14(task.imei2);
  const i2_full = i2_14 ? (i2_14 + calcLuhn14to15(i2_14)) : i1_full;

  
  const payloadObj = {
    sid: "1", salt: "2",
    product, cpuId, realCpuId: cpuId,
    imei1: i1_full, imei2: i2_full, meid: "",
    wifiMac: (task.btmac || "").trim(),
    btMac  : (task.wmac || "").trim(),
    ufsId: "", countryCode: "GL"
  };

  const payload = obfuscate(JSON.stringify(payloadObj));

 
  const res = await fetch(API_BASE + "critical/save", {
    method: "POST",
    headers: { "content-type": "application/x-www-form-urlencoded" },
    body: "payload=" + encodeURIComponent(payload)
  });

  const txt = await res.text();
  if (!res.ok) throw new Error(`Sunucu Hatası (HTTP ${res.status}): ${txt}`);

  const infoBlock = decodeServerResponse(txt);
  if (!/criticalData:/i.test(infoBlock)) {
    throw new Error("Sunucudan gelen yanıt geçersiz.");
  }

  const blob = new Blob([infoBlock], { type: "text/plain;charset=utf-8" });
  if (blob.size < 1100) {
    throw new Error(`Geçersiz dosya boyutu (${blob.size} bayt).`);
  }


  const date = new Date();
  const dateStr = `${String(date.getDate()).padStart(2,'0')}${String(date.getMonth()+1).padStart(2,'0')}${date.getFullYear()}`;
  const name = `${product}_${i1_14}_${i2_14}_${dateStr}_RSCPID.bin`;


  await saveCriticalToServer(blob, name);


  try {
    const creditRes = await fetch(AUTH_BASE + "/credit/consume", {
      method: "POST",
      headers: { "content-type": "application/json" },
      body: JSON.stringify({ amount: 1 })
    });
    const creditData = await creditRes.json().catch(() => null);
    if (creditData?.ok) {
      currentUserCredit = creditData.credit;
      const uc = $("userCredit");
      if (uc) uc.textContent = "credit: " + currentUserCredit;
    }
  } catch (e) {
    console.warn("Kredi düşürme hatası:", e);
  }

 
  const downloadLink = $('downloadLink');
  if (downloadLink) {
    downloadLink.href = URL.createObjectURL(blob);
    downloadLink.download = name;
    downloadLink.style.display = 'inline-flex';
  }

  return true;
}


function sanitize14(v) {
    return v.replace(/\D/g, "").slice(0, 14);
}

function calcLuhn14to15(n14) {
    if (typeof n14 !== 'string' || n14.length !== 14) return '';
    let sum = 0, dbl = true;
    for (let i = n14.length - 1; i >= 0; i--) {
        let d = n14.charCodeAt(i) - 48;
        if (dbl) {
            d = d * 2;
            if (d > 9) d -= 9;
        }
        sum += d;
        dbl = !dbl;
    }
    return String((10 - (sum % 10)) % 10);
}

function fillFormWithTaskSilent(task) {
  const setValue = (id, value) => {
    const el = byId(id);
    if (el) {
      el.setAttribute('data-rsq-silent', 'true');
      el.value = value || '';
    }
  };

  setValue('product', task.product);
  setValue('cpuId', task.cpuId);
  setValue('imei1', task.imei1);
  setValue('imei2', task.imei2);
  setValue('btmac', task.btmac);
  setValue('wmac', task.wmac);

  ['imei1', 'imei2'].forEach(id => {
    const el = byId(id);
    if (el && el.hasAttribute('data-rsq-silent')) {
      el.removeAttribute('data-rsq-silent');
    }
  });
}

function restoreFormValuesSilent(values, activeElement) {
  if (!values) return;
  
  const setValue = (id, value) => {
    const el = byId(id);
    if (el) {
      el.setAttribute('data-rsq-silent', 'true');
      el.value = value || '';
    }
  };

  setValue('product', values.product);
  setValue('cpuId', values.cpuId);
  setValue('imei1', values.imei1);
  setValue('imei2', values.imei2);
  setValue('btmac', values.btmac);
  setValue('wmac', values.wmac);

  ['product', 'cpuId', 'imei1', 'imei2', 'btmac', 'wmac'].forEach(id => {
    const el = byId(id);
    if (el && el.hasAttribute('data-rsq-silent')) {
      el.removeAttribute('data-rsq-silent');
    }
  });

  if (activeElement && activeElement.focus && document.contains(activeElement)) {
    try {
      activeElement.focus();
    } catch (e) {

    }
  }
}
  function backupFormValues() {
    return {
      product: byId('product')?.value,
      cpuId: byId('cpuId')?.value,
      imei1: byId('imei1')?.value,
      imei2: byId('imei2')?.value,
      btmac: byId('btmac')?.value,
      wmac: byId('wmac')?.value
    };
  }

  function fillFormWithTask(task) {
    const setValue = (id, value) => {
      const el = byId(id);
      if (el) el.value = value || '';
    };

    setValue('product', task.product);
    setValue('cpuId', task.cpuId);
    setValue('imei1', task.imei1);
    setValue('imei2', task.imei2);
    setValue('btmac', task.btmac);
    setValue('wmac', task.wmac);

    ['imei1', 'imei2'].forEach(id => {
      const el = byId(id);
      if (el && 'oninput' in el) el.oninput?.();
    });
  }

  function restoreFormValues(values) {
    if (!values) return;
    
    const setValue = (id, value) => {
      const el = byId(id);
      if (el) el.value = value || '';
    };

    setValue('product', values.product);
    setValue('cpuId', values.cpuId);
    setValue('imei1', values.imei1);
    setValue('imei2', values.imei2);
    setValue('btmac', values.btmac);
    setValue('wmac', values.wmac);
  }

  function startScheduler() {
    if (schedulerInterval) {
      clearInterval(schedulerInterval);
    }
    
    schedulerState = SchedulerStatus.RUNNING;
    schedulerInterval = setInterval(processNextTask, 100);
    updateSchedulerStatus();
    showNotification('Görev planlayıcı başlatıldı', 'success');
  }

	function pauseScheduler() {
		if (schedulerInterval) {
		  clearInterval(schedulerInterval);
		  schedulerInterval = null;
		}
		
		taskTimeouts.forEach((timeoutId, taskId) => {
		  clearTimeout(timeoutId);
		});
		taskTimeouts.clear();
		
		schedulerState = SchedulerStatus.PAUSED;
		updateSchedulerStatus();
		showNotification('Görev planlayıcı duraklatıldı', 'warning');
	}

	function stopScheduler() {
		if (schedulerInterval) {
		  clearInterval(schedulerInterval);
		  schedulerInterval = null;
		}
				taskTimeouts.forEach((timeoutId, taskId) => {
		  clearTimeout(timeoutId);
		});
		taskTimeouts.clear();
		
		schedulerState = SchedulerStatus.STOPPED;
		updateSchedulerStatus();
		showNotification('Görev planlayıcı durduruldu', 'info');
	}

  function bindEvents() {
    byId('rsqOpen')?.addEventListener('click', () => {
      byId('rsq-modal').classList.add('show');
      render();
    });
    
    byId('rsqClose')?.addEventListener('click', () => {
      byId('rsq-modal').classList.remove('show');
    });
    
    byId('rsqAdd')?.addEventListener('click', addFromForm);

    byId('btnStartScheduler')?.addEventListener('click', startScheduler);
    byId('btnPauseScheduler')?.addEventListener('click', pauseScheduler);
    byId('btnClearDone')?.addEventListener('click', () => {
      const initialLength = tasks.length;
      tasks = tasks.filter(t => t.status !== TaskStatus.OK);
      save(tasks);
      render();
      
      const removed = initialLength - tasks.length;
      if (removed > 0) {
        showNotification(`${removed} tamamlanmış görev temizlendi`, 'success');
      }
    });

	byId('tasksTbody')?.addEventListener('click', async (e) => {
	  const btn = e.target.closest('button[data-act]');
	  if (!btn) return;

	  const tr = e.target.closest('tr');
	  if (!tr) return;

	  const id = tr.getAttribute('data-id');
	  const idx = tasks.findIndex(x => x.id === id);
	  if (idx < 0) return;

	  const task = tasks[idx];
	  const action = btn.dataset.act;

	  switch (action) {
		case 'del':
		  if (taskTimeouts.has(task.id)) {
			clearTimeout(taskTimeouts.get(task.id));
			taskTimeouts.delete(task.id);
		  }
		  tasks.splice(idx, 1);
		  save(tasks);
		  render();
		  showNotification('Görev silindi', 'info');
		  break;

		case 'try': {
		  const now = cnNow();
		  task.currentWindowStart = now;
		  task.currentWindowEnd   = new Date(now.getTime() + CHINA_WINDOW_DURATION);
		  task.status = TaskStatus.WAIT;
		  save(tasks);
		  render();
		  await runWithSlot(task);
		  break;
		}

		case 'edit':
		  showNotification('Düzenleme özelliği yakında eklenecek', 'info');
		  break;
	  }
	});


    byId('rsq-modal')?.addEventListener('click', (e) => {
      if (e.target === byId('rsq-modal')) {
        byId('rsq-modal').classList.remove('show');
      }
    });

    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape' && byId('rsq-modal').classList.contains('show')) {
        byId('rsq-modal').classList.remove('show');
      }
    });
  }

  function initialize() {
    ensureUI();
    bindEvents();
    render();
    updateSchedulerStatus();
    
    setInterval(() => {
      if (byId('rsq-modal').classList.contains('show')) {
        render();
      }
    }, 1000);
    
    showNotification('Görev yöneticisi yüklendi', 'success');
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initialize);
  } else {
    initialize();
  }
})();